#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using REPORT = gov.va.med.vbecs.reports;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_TransfusionReactionWorkupReport : BaseTest
	{
		Guid _trwGuid;
		DataRow _drTrw = null;
		BOL.TransfusionReactionWorkupReport _report;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				_drTrw = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM dbo.PatientTransfusionReaction WHERE RecordStatusCode = 'A' AND PartialSaveId > 3");
				//
				this.RefreshData = false;
			}
			//
			this._trwGuid = (Guid)_drTrw[TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid];
			_report = new BOL.TransfusionReactionWorkupReport();
		}

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsNotNull(new BOL.TransfusionReactionWorkupReport(),"Constructor");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void PatientTransfusionReactionGuid_Pass()
		{
			_report.PatientTransfusionReactionGuid = _trwGuid;
			Assert.AreEqual(_trwGuid,_report.PatientTransfusionReactionGuid,"PatientTransfusionReactionGuid");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientTransfusionReactionGuid_Fail()
		{
		}

		[Test]
		public void GenerateReport_Pass()
		{
			_report.PatientTransfusionReactionGuid = _trwGuid;
            _trwGuid = new System.Guid();
            //TODO: FIx once Kman migrates this report.
            //REPORT.TransfusionReactionWorkupReport.TransfusionReactionWorkupReport rpt = _report.GenerateReport(Environment.UserName);
            //
            Assert.IsNotNull(_trwGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GenerateReport_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass()
		{
			//Sends report to printer
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Fail()
		{
			//Sends report to printer
		}
	}
}
#endif
